/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Healpix;
import cds.moc.HealpixImpl;
import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.MocCell;
import cds.moc.STMoc;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class SMoc
extends Moc1D {
    public static final int MAXORD_S = 29;
    public static final int FACT_S = 4;
    public static final char DIM_S = 's';
    public static final long NBVAL_S = SMoc.pow2(29L) * SMoc.pow2(29L) * 12L;
    public static final String SYS_S = "C";
    private int minOrder;

    @Override
    public final int maxOrder() {
        return 29;
    }

    @Override
    public final int shiftOrder() {
        return 2;
    }

    @Override
    public final char cDim() {
        return 's';
    }

    @Override
    public final long maxVal() {
        return NBVAL_S;
    }

    @Override
    public final String sys() {
        return SYS_S;
    }

    public SMoc() {
    }

    public SMoc(int mocOrder) {
        super(mocOrder);
    }

    public SMoc(String s) throws Exception {
        super(s);
    }

    public SMoc(SMoc moc) throws Exception {
        super(moc);
    }

    public SMoc(InputStream in) throws Exception {
        super(in);
    }

    @Override
    public void clear() {
        super.clear();
        this.minOrder = 0;
    }

    @Override
    public SMoc clone() throws CloneNotSupportedException {
        SMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof SMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be SMoc");
        }
        super.clone1(moc);
        ((SMoc)moc).minOrder = this.minOrder;
    }

    @Override
    public SMoc dup() {
        SMoc moc = new SMoc();
        moc.sys = this.sys;
        return moc;
    }

    @Override
    public int sizeOfCoding() {
        return this.getDeepestOrder() < 14 ? 4 : 8;
    }

    @Override
    public int getNbCoding() {
        return this.getNbCells();
    }

    @Override
    public void add(Moc moc) throws Exception {
        if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc for adding");
        }
        super.add(moc);
    }

    public void add(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getMocOrder();
        if (order == -1) {
            throw new Exception("Undefined Moc order");
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        this.add(order, npix, npix);
    }

    public boolean contains(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getDeepestOrder();
        if (order == -1) {
            return false;
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        return this.isIncluding(order, npix);
    }

    public SMoc queryDisc(HealpixImpl healpix, double alpha, double delta, double radius) throws Exception {
        long[] list;
        int order = this.getDeepestOrder();
        if (order == -1) {
            return null;
        }
        SMoc mocA = this.dup();
        for (long npix : list = healpix.queryDisc(order, alpha, delta, radius)) {
            mocA.add(order, npix, npix);
        }
        return this.intersection(mocA);
    }

    @Override
    public void setSpaceSys(String coosys) {
        this.setSys(coosys);
    }

    @Override
    public String getSpaceSys() {
        return this.getSys();
    }

    @Override
    public void setMinOrder(int minOrder) throws Exception {
        if (minOrder == this.minOrder) {
            return;
        }
        if (minOrder < 0 || minOrder > this.maxOrder()) {
            throw new Exception("MinOrder error (" + minOrder + " not in [0.." + this.maxOrder() + "])");
        }
        if (this.mocOrder != -1 && minOrder > this.mocOrder) {
            throw new Exception("MinOrder cannot be bigger that Moc order");
        }
        this.minOrder = minOrder;
        this.resetCache();
    }

    @Override
    public int getMinOrder() {
        return this.minOrder;
    }

    public double getAngularRes() {
        return Math.sqrt(Healpix.getPixelArea(this.getMocOrder()));
    }

    public boolean contains(long npix) {
        return this.range.contains(npix);
    }

    public SMoc[] split(HealpixImpl healpix, boolean flagStrict) throws Exception {
        if (this.isFull()) {
            return new SMoc[]{this.clone()};
        }
        int gap = flagStrict ? 2 : 1;
        ArrayList<SMoc> res = new ArrayList<SMoc>();
        SMoc done = this.dup();
        int deepOrder = this.getDeepestOrder();
        int order = this.getMocOrder();
        done.setMocOrder(deepOrder);
        Stack<Long> stack = new Stack<Long>();
        Iterator<Long> it = this.valIterator();
        while (it.hasNext()) {
            long pix = it.next() >> (order - deepOrder) * 2;
            if (done.isIncluding(deepOrder, pix)) continue;
            stack.add(pix);
            SMoc m1 = this.dup();
            m1.setMocOrder(order);
            while (!stack.isEmpty()) {
                pix = (Long)stack.pop();
                done.add(deepOrder, pix);
                m1.add(deepOrder, pix);
                long[] n = healpix.neighbours(deepOrder, pix);
                for (int i = 0; i < n.length; i += gap) {
                    long pn = n[i];
                    if (done.isIncluding(deepOrder, pn) || !this.isIncluding(deepOrder, pn)) continue;
                    stack.add(pn);
                }
            }
            res.add(m1);
        }
        SMoc[] ares = new SMoc[res.size()];
        res.toArray(ares);
        return ares;
    }

    @Override
    public boolean isIncluding(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc isIncluding test");
        }
        if (!((SMoc)moc).isCompatible(this)) {
            throw new Exception("Uncompatible sys");
        }
        this.flush();
        return this.range.contains(((SMoc)moc).range);
    }

    @Override
    public boolean isIntersecting(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc isIncluding test");
        }
        this.flush();
        return this.range.overlaps(((SMoc)moc).range);
    }

    @Override
    public SMoc union(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc union");
        }
        return (SMoc)super.union(moc);
    }

    @Override
    public SMoc intersection(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc subtraction");
        }
        return (SMoc)super.intersection(moc);
    }

    @Override
    public SMoc subtraction(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc subtraction");
        }
        return (SMoc)super.subtraction(moc);
    }

    @Override
    public SMoc complement() throws Exception {
        return (SMoc)super.complement();
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        int mocOrder = -1;
        String val = header.getStringFromHeader("MOCORD_S");
        if (val == null) {
            val = header.getStringFromHeader("MOCORDER");
        }
        try {
            mocOrder = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setMocOrder(mocOrder);
        String type = header.getStringFromHeader("ORDERING");
        String sys = header.getStringFromHeader("COORDSYS");
        if (sys != null && !sys.equals(SYS_S)) {
            this.setSpaceSys(sys);
        }
        if (type != null && type.equals("RANGE")) {
            this.readSpecificDataRange(in, naxis1, naxis2, nbyte);
        } else {
            this.readSpecificDataUniq(in, naxis1, naxis2, nbyte);
        }
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(SMoc.getFitsLine("TTYPE1", "UNIQ", "UNIQ pixel number"));
        n += 80;
        out.write(SMoc.getFitsLine("ORDERING", "NUNIQ", "NUNIQ coding method"));
        n += 80;
        out.write(SMoc.getFitsLine("COORDSYS", this.getSpaceSys(), "Space reference frame"));
        n += 80;
        out.write(SMoc.getFitsLine("MOCDIM", "SPACE", "Physical dimension"));
        n += 80;
        out.write(SMoc.getFitsLine("MOCORD_S", "" + this.getMocOrder(), "MOC resolution (best order)"));
        n += 80;
        out.write(SMoc.getFitsLine("MOCORDER", "" + this.getMocOrder(), "=MOCORD_S (backward compatibility)"));
        return n += 80;
    }

    @Override
    protected int writeSpecificData(OutputStream out) throws Exception {
        int size = 0;
        byte[] buf = new byte[this.sizeOfCoding()];
        Iterator<MocCell> it = this.cellIterator(true);
        while (it.hasNext()) {
            MocCell cell = it.next();
            for (long val = cell.start; val < cell.end; ++val) {
                long nuniq = SMoc.hpix2uniq(cell.order, val);
                size += SMoc.writeVal(out, nuniq, buf);
            }
        }
        return size;
    }
}

